/* 
 *  ForceReadyRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class ForceReadyRequest extends MonitoredUserRequest {

    private static final Logger LOG = Logger.getLogger(ForceReadyRequest.class);

    public ForceReadyRequest(String supervisorId, String userID) {
        super(LOG, supervisorId, userID);
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getMonitoredUser().forceReady();
        LOG.trace(methodName + "-");
        return null;
    }
}
